/*
 * UIPEthernet EchoServer example.
 *
 * UIPEthernet is a TCP/IP stack that can be used with a enc28j60 based
 * Ethernet-shield.
 *
 * UIPEthernet uses the fine uIP stack by Adam Dunkels <adam@sics.se>
 * Adaption to Enc28J60 by Norbert Truchsess <norbert.truchsess@t-online.de>
 */

#include <UIPEthernet.h>

EthernetClient client;
signed long next;
float calibration = 0.4887;
float tempC; 

void setup() {

  pinMode(A0, INPUT);   // set pin to Analog1

  Serial.begin(9600);

  uint8_t mac[6] = {0x00,0x01,0x02,0x03,0x04,0x05};

 
  // Static IP 
 IPAddress myIP(192,168,1,11);
 Ethernet.begin(mac,myIP);
 
 // Dynamic IP  
 // Ethernet.begin(mac);

  Serial.print("localIP: ");
  Serial.println(Ethernet.localIP());
  Serial.print("subnetMask: ");
  Serial.println(Ethernet.subnetMask());
  Serial.print("gatewayIP: ");
  Serial.println(Ethernet.gatewayIP());
  Serial.print("dnsServerIP: ");
  Serial.println(Ethernet.dnsServerIP());

  next = 0;
}

void loop() {

  // after 2 second send string to Server
  if (((signed long)(millis() - next)) > 0)
    {
      next = millis() + 1000; 
      // Server "scada" IP & Port 
      if (client.connect(IPAddress(192,168,1,111 )/*Server ip*/,10000/*port*/))
        {
          Serial.println("Client connected.\n");
          tempC =  analogRead(A0) * calibration ; //  LM35
          Serial.println("Client connected and Send :" + String(tempC, DEC));
          Serial.println("\n");

          // send to Server string with adc value  
          // server <- "124"  
          client.print(String(tempC, DEC));
          
          //disconnect client
          Serial.println("Client disconnect");
          client.stop();
        }
      else
        Serial.println("Client connect failed");
    }
}




 
