/*
 * UIPEthernet EchoServer example.
 *
 * UIPEthernet is a TCP/IP stack that can be used with a enc28j60 based
 * Ethernet-shield.
 *
 * UIPEthernet uses the fine uIP stack by Adam Dunkels <adam@sics.se>
 * Adaption to Enc28J60 by Norbert Truchsess <norbert.truchsess@t-online.de>
 */


#include <UIPEthernet.h>

  EthernetServer server = EthernetServer(10001);

void setup()
{
  Serial.begin(9600);


  uint8_t mac[6] = {0x00,0x01,0x02,0x03,0x04,0x05};
  
   // Static IP 
  IPAddress myIP(192,168,1,11);
  Ethernet.begin(mac,myIP);

  // Dynamic IP  For simulation
  //Ethernet.begin(mac);

  Serial.print("localIP: ");
  Serial.println(Ethernet.localIP());
  Serial.print("subnetMask: ");
  Serial.println(Ethernet.subnetMask());
  Serial.print("gatewayIP: ");
  Serial.println(Ethernet.gatewayIP());
  Serial.print("dnsServerIP: ");
  Serial.println(Ethernet.dnsServerIP());

  for (byte thisByte = 0; thisByte < 4; thisByte++) {
    // print the value of each byte of the IP address:
    Serial.print(Ethernet.localIP()[thisByte], DEC);
    Serial.print("-");
  }
  Serial.println(" TCP Server.");
  server.begin();

}

void loop()
{
  size_t size;


  delay(100);
  
  if (EthernetClient client = server.available())
    {
      while((size = client.available()) > 0)
        {
          uint8_t* msg = (uint8_t*)malloc(size);
          size = client.read(msg,size);
          Serial.write(msg,size);
         Serial.println("");
          
          free(msg);
        }
      // Message To Client
      client.print("*DATA from Client*!");
      //client.stop();
    }
    
}
