/*
 Simple Micset text LZ Communication 
 Read Write Arduino IO and Variables
*/


#include <UIPEthernet.h>

EthernetServer server = EthernetServer(10000);

const int ledPin =  8;              // the number of the LED pin
int ledState = LOW;                 // ledState used to set the LED
unsigned long previousMillis = 0;   // will store last time LED was updated

// **** bagin  LZ *****

const int  LED1 = 4;
const int  LED2 = 5;

const int  BUT1 = 6;
const int  BUT2 = 7;


const int    MAXTAG = 7;
const int    COMMAND_LEN = 3;
const String LineEnd = String("*");

typedef struct TTags  {
  String TagName;
  float TagValue;  
  char TagType;    // ( 'F' Float  Format "123.56" )  , ( 'N'  Integer Format Result "1" ) 
};
TTags Tags[MAXTAG];


void ScanLZPacked(void) {

  String StringBuf;
  String ValueString;
  size_t size;

  // (client Scada query) <-> (Server Arduino reply) example
  // query "L1:1."  Set "L1" = 1  reply "*"
  // query "L1:."   Get "L1"      reply  "L1:1" or "L1:0"
  // query "D1:."   Get "D1"      reply  "D1:123.00"
  // query "D1:45." Set "D1" = 45 reply "*"


  if (EthernetClient client = server.available()) {
    if ((size = client.available()) > 3) {

      uint8_t* msg = (uint8_t*)malloc(size);
      size = client.read(msg, size);

      // convert buffer to string
      StringBuf = "";
      for ( int i = 0; i < size ; i++ )
        StringBuf += (char)msg[i];

      if (StringBuf.endsWith(LineEnd)) {
        // find TagName
        for ( int i = 0; i < MAXTAG ; i++ ) {
          if ( StringBuf.startsWith(Tags[i].TagName ) ) {
            ValueString = StringBuf.substring(COMMAND_LEN, StringBuf.length() - LineEnd.length());
            if ( ValueString.length() > 0 ) {
              Tags[i].TagValue = ValueString.toFloat();
              client.print(LineEnd);
            }  else {
              if ( Tags[i].TagType == 'F' ) StringBuf =  Tags[i].TagValue  ; else            
              if ( Tags[i].TagType == 'I' ) StringBuf =  (int)Tags[i].TagValue  ;             
              client.print(Tags[i].TagName + StringBuf + LineEnd);
            }; // end else
            break;
          };// endif
        };//end for
      };// end if
      free(msg);
    };// end if
    //client.stop();
  };//end if

}// end ReadFromScada

// ***** end LZ *****

void setup()
{
  Serial.begin(9600);

  // define LZ tags
  Tags[0] = (TTags) { "A1:", 10.5 , 'F' };  // Default Value = 10.5   Analog 1 
  Tags[1] = (TTags) { "A2:", 20.5 , 'F' };  // Default Value = 20.5   Analog 2
  Tags[2] = (TTags) { "B1:", 0 , 'I' };     // Default Value = 0      Button 1
  Tags[3] = (TTags) { "B2:", 0 , 'I' };     // Default Value = 0      Button 2
  Tags[4] = (TTags) { "L1:", 0 , 'I' };     // Default Value = 0      Led 1
  Tags[5] = (TTags) { "L2:", 0 , 'I' };     // Default Value = 0      Led 2
  Tags[6] = (TTags) { "D1:", 100 , 'F'};    // Default Value = 100    Delay Time

  pinMode(BUT1, INPUT);   // set pin to input Button 1
  pinMode(BUT2, INPUT);   // set pin to input Button 2

  pinMode(LED1, OUTPUT);  // set pin to Led 1
  pinMode(LED2, OUTPUT);  // set pin to Led 2

  pinMode(A0, INPUT);     // set pin to Analog1
  pinMode(A1, INPUT);     // set pin to Analog2

  pinMode(8, OUTPUT);   // set pin to Led 1


  uint8_t mac[6] = {0x00, 0x01, 0x02, 0x03, 0x04, 0x05};

  Serial.println("Wait. ");

  // *** Static IP
  IPAddress myIP(192, 168, 1, 11);
  Ethernet.begin(mac, myIP);

  // *** Dynamic IP  For simulation
  //Ethernet.begin(mac);

  Serial.print("localIP: ");
  Serial.println(Ethernet.localIP());
  Serial.print("subnetMask: ");
  Serial.println(Ethernet.subnetMask());
  Serial.print("gatewayIP: ");
  Serial.println(Ethernet.gatewayIP());
  Serial.print("dnsServerIP: ");
  Serial.println(Ethernet.dnsServerIP());

  Serial.println(" TCP Server.");
  server.begin();
}

void loop()
{


  Tags[0].TagValue = (float)analogRead(A0); // Analog 1
  Tags[1].TagValue = (float)analogRead(A1); // Analog 1

  //  Get Buttons
  Tags[2].TagValue = digitalRead(BUT1);  // Get Button 1
  Tags[3].TagValue = digitalRead(BUT2);  // Get Button 2

  // Set Leds
  if ( Tags[4].TagValue == 1  ) digitalWrite(LED1, HIGH);  else  digitalWrite(LED1, LOW);
  if ( Tags[5].TagValue == 1 ) digitalWrite(LED2, HIGH);  else  digitalWrite(LED2, LOW);

  ScanLZPacked();

  //Serial.println( Tags[4].TagValue );


  // ... task
  delay(10);

  unsigned long currentMillis = millis();
  if (currentMillis - previousMillis >= Tags[6].TagValue) {
    // save the last time you blinked the LED
    previousMillis = currentMillis;

    if (ledState == LOW)  ledState = HIGH;
    else                  ledState = LOW;

    // set the LED with the ledState of the variable:
    digitalWrite(ledPin, ledState);
  };




}
